
/**
* Copyright (c) 2015 - atom0s [atom0s@live.com]
*
* GDHook is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* GDHook is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with GDHook.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "ExamplePlugin.h"

/**
 * @brief Constructor and Deconstructor
 */

ExamplePlugin::ExamplePlugin(void)
    : m_Direct3DDevice9(nullptr)
    , m_HookCore(nullptr)
    , m_PluginId(0)
{ }
ExamplePlugin::~ExamplePlugin(void)
{ }

/**
 * @brief Returns this plugins data information structure.
 *
 * @return This plugins data information structure.
 */
PluginData ExamplePlugin::GetPluginData(void)
{
    return (*g_PluginData);
}

/**
 * @brief Initializes our plugin. This is the main call that happens when your plugin is loaded.
 *
 * @param hookCore          The main hook core object interface to interact with the hook.
 * @param dwPluginId        The base address of your plugin. This is used as the ID.
 *
 * @return True on success, false otherwise.
 *
 * @note If your plugin returns false here, it will be unloaded immediately!
 */
bool ExamplePlugin::Initialize(IHookCore* hookCore, DWORD dwPluginId)
{
    this->m_HookCore = hookCore;
    this->m_PluginId = dwPluginId;

    return true;
}

/**
 * @brief Releases this plugin. This is called when your plugin is unloaded.
 *
 * @note Your plugin should cleanup all its data here before it unloads.
 */
void ExamplePlugin::Release(void)
{
}

/**
 * @brief Allows a plugin to attempt to handle a console command.
 *
 * @param command               The command being processed.
 *
 * @return True on handled, false otherwise.
 */
bool ExamplePlugin::HandleCommand(const char* command)
{
    return false;
}

/**
 * @brief Direct3D initialize call to prepare this plugin for Direct3D calls.
 *
 * @param lpDevice              The Direct3D device currently wrapped by GDHook.
 *
 * @return True on success, false otherwise.
 *
 * @note    Plugins that do not return true on this call will not receive any other
 *          Direct3D calls listed below!
 */
bool ExamplePlugin::Direct3DInitialize(IDirect3DDevice9* lpDevice)
{
    this->m_Direct3DDevice9 = lpDevice;
    return true;
}

/**
 * @brief Direct3D release call to allow this plugin to cleanup any Direct3D objects.
 */
void ExamplePlugin::Direct3DRelease(void)
{
}

/**
 * @brief Direct3D pre-render call to allow this plugin to prepare for rendering.
 *
 * @note This will only be called if you returned true in Direct3DInitialize!
 */
void ExamplePlugin::Direct3DPreRender(void)
{
}

/**
 * @brief Direct3D render call to allow this plugin to render.
 *
 * @note This will only be called if you returned true in Direct3DInitialize!
 */
void ExamplePlugin::Direct3DRender(void)
{
}

/**
 * @brief Direct3D pre-reset call to allow this plugin to cleanup before the device resets.
 *
 * @note This will only be called if you returned true in Direct3DInitialize!
 */
void ExamplePlugin::Direct3DPreReset(void)
{
}

/**
 * @brief Direct3D post-reset call to allow this plugin to recreate its objects after the device resets.
 *
 * @note This will only be called if you returned true in Direct3DInitialize!
 */
void ExamplePlugin::Direct3DPostReset(void)
{
}

/**
 * @brief Direct3D pre-present call to allow this plugin to prepare for presentation.
 *
 * @param pSourceRect           The source rect that is being presented.
 * @param pDestRect             The destination rect to present to.
 * @param hDestWindowOverride   The hWnd override (if any) to present to.
 * @param pDirtyRegion          The dirty region of the presentation.
 *
 * @note This will only be called if you returned true in Direct3DInitialize!
 */
void Direct3DPrePresent(const RECT* pSourceRect, const RECT* pDestRect, HWND hDestWindowOverride, const RGNDATA* pDirtyRegion);

/**
 * @brief Direct3D post-present call to allow this plugin to complete presentation.
 *
 * @param pSourceRect           The source rect that is being presented.
 * @param pDestRect             The destination rect to present to.
 * @param hDestWindowOverride   The hWnd override (if any) to present to.
 * @param pDirtyRegion          The dirty region of the presentation.
 *
 * @note This will only be called if you returned true in Direct3DInitialize!
 */
void Direct3DPostPresent(const RECT* pSourceRect, const RECT* pDestRect, HWND hDestWindowOverride, const RGNDATA* pDirtyRegion);

/**
 * @brief Gets the interface version this plugin was compiled with.
 *
 * @note This is a required export, your plugin must implement this!
 */
__declspec(dllexport) double __stdcall GetInterfaceVersion(void)
{
    return GDHOOK_INTERFACE_VERSION;
}

/**
 * @brief Gets the plugin data for this plugin.
 *
 * @note This is a required export, your plugin must implement this!
 */
__declspec(dllexport) void __stdcall CreatePluginData(PluginData* lpBuffer)
{
    g_PluginData = lpBuffer;

    strcpy_s(g_PluginData->Name, sizeof(g_PluginData->Name), "ExamplePlugin");
    strcpy_s(g_PluginData->Author, sizeof(g_PluginData->Author), "atom0s");

    g_PluginData->InterfaceVersion = GDHOOK_INTERFACE_VERSION;
    g_PluginData->PluginVersion = 1.00f;
    g_PluginData->Priority = 0;
}

/**
 * @brief Creates an instance of this plugin object.
 *
 * @note This is a required export, your plugin must implement this!
 */
__declspec(dllexport) IPlugin* __stdcall CreatePlugin(char* pszReserved)
{
    UNREFERENCED_PARAMETER(pszReserved);
    return (IPlugin*)new ExamplePlugin();
}
